package com.ejie.p06b.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;

import com.ejie.p06b.datatype.model.P06B47T00Datatype;
import com.ejie.p06b.general.P06BTablas;
import com.ejie.p06b.log.P06BLog;
import com.ejie.p06b.util.bd.P06BServidorConexionesBD;

/**
 * Fecha de creacin: (26/01/2012)
 */
public class P06B47T00DAO {
	
	static private P06B47T00DAO instance = null;

	public static P06B47T00DAO getInstance() {
	     if (instance == null) {
	          synchronized (P06B47T00DAO.class) {
	          		if (instance == null) {
	                     instance = new P06B47T00DAO();
	                }
	          }
	     }
	     return instance;
	}
	
	/**
    * Obtiene la lista de entidades del Modelo 2.1 de la DEC, asociadas al expediente y ejercicio
    * @param ejer.
    * @param numExp          
    * @return Lista de entidades DEC Modelo 2.1
	 * @throws Exception
    */
	public ArrayList selectAllByEjerExp(String ejer, String numExp) throws Exception{
		P06BLog.send(2,this, "Inicio P06B47T00DAO-selectAllByEjerExp");
		ArrayList lista = new ArrayList();
		P06B47T00Datatype obj = null;
		PreparedStatement lstm  = null;
        ResultSet lrst  = null;
        String sql = SELECTALL_BY_EJEREXP;
        Connection lconConexion = P06BServidorConexionesBD.getConexionConsultas();
        try {
        	lstm = lconConexion.prepareStatement(sql);
        	lstm.setString(1,ejer.toUpperCase());
        	lstm.setString(2,numExp.toUpperCase());
        	lrst = lstm.executeQuery();
	        while (lrst.next()){
	        	obj = new P06B47T00Datatype();

			    obj.setEjercicio(lrst.getString(P06BTablas.P06B_P06B47_EJERCICIO));
			    obj.setNumExp(lrst.getString(P06BTablas.P06B_P06B47_NUMEXP));
			    obj.setClave(lrst.getString(P06BTablas.P06B_P06B47_CLAVE));
			    obj.setDenom(lrst.getString(P06BTablas.P06B_P06B47_DENOM)==null?"":lrst.getString(P06BTablas.P06B_P06B47_DENOM));
			    obj.setVoltotPrimas(lrst.getString(P06BTablas.P06B_P06B47_VOLTOT_PRIMAS)==null?"":lrst.getString(P06BTablas.P06B_P06B47_VOLTOT_PRIMAS));
			    obj.setNuevaPrimas(lrst.getString(P06BTablas.P06B_P06B47_NUEVA_PRIMAS)==null?"":lrst.getString(P06BTablas.P06B_P06B47_NUEVA_PRIMAS));
			    
	        	lista.add(obj);
	        }
	        P06BLog.send(2,this, "Fin P06B47T00DAO-selectAllByEjerExp");
	    } catch (SQLException e) {
	    	P06BLog.send(2,this, "error: " +e.getMessage());
        	try {
        		if(lrst!=null)
        			lrst.close();
        	}catch (Exception rse) {}
	        try {
	        	if(lstm!=null)
	        		lstm.close();
	        }catch (Exception sse) {}
	        try {
	        	if(lconConexion!=null)
	        		lconConexion.close();
	        }catch (Exception cse) {}
	        //Propago la excepcin
	        throw e;
	    }catch (Exception e2) {	 
        	P06BLog.send(2,this, "error: " +e2.getMessage());
        	try {
        		if(lrst!=null)
        			lrst.close();
        	}catch (Exception rse) {}
	        try {
	        	if(lstm!=null)
	        		lstm.close();
	        }catch (Exception sse) {}
	        try {
	        	if(lconConexion!=null)
	        		lconConexion.close();
	        }catch (Exception cse) {}
	        //Propago la excepcin
	        throw e2;
	    }finally {
	    	try {
        		if(lrst!=null)
        			lrst.close();
        	}catch (Exception rse) {}
	        try {
	        	if(lstm!=null)
	        		lstm.close();
	        }catch (Exception sse) {}
	        try {
	        	if(lconConexion!=null)
	        		lconConexion.close();
	        }catch (Exception cse) {}
	    }
		return lista;
	}
	

	private static String SELECTALL_BY_EJEREXP =
		"SELECT "
		+ P06BTablas.P06B_P06B47_EJERCICIO + ", "
		+ P06BTablas.P06B_P06B47_NUMEXP + ", "
		+ P06BTablas.P06B_P06B47_CLAVE + ", "
		+ P06BTablas.P06B_P06B47_DENOM + ", "
		+ P06BTablas.P06B_P06B47_VOLTOT_PRIMAS + ", "
		+ P06BTablas.P06B_P06B47_NUEVA_PRIMAS +
		
		" FROM " + P06BTablas.P06B_P06B47T00_TABLA 
		+ " WHERE " + P06BTablas.P06B_P06B47_EJERCICIO + "= ?" 
			+ " AND " + P06BTablas.P06B_P06B47_NUMEXP + "= ?"
		+" ORDER BY " + P06BTablas.P06B_P06B47_CLAVE;

}
